## 4b: Older cohorts’ drawdowns from wealth increase over time
## Drawdown rates on other assets for cohorts aged 65+ increase by 5 per cent of base scenario rates each year for next 10 years 
## and then stay stable (new rates range from 6–10 per cent). Drawdown rates on housing for cohorts aged 70+ increase by 
## 15 per cent of base scenario rates each year for next 10 years and then stay stable (new rates range from 0.7–1.3 per cent).


# Prelims -----------------------------------------------------------------

gc()


# Read in base params ---------------------------------------------

## starting cohort pathways (from step 3)
starting_cohorts_pathways <- qread(starting_cohorts_pathways_file)


# Adjust for scenario -----------------------------------------------------

drawdown_adj <- starting_cohorts_pathways %>% 
  distinct(age_grp, ho, year, other_asset_drawdown_param, housing_asset_saving_param) %>% 
  ## assume other asset drawdowns increase by extra 5% each year for 65+ for next 10 years and then stay stable
  mutate(other_asset_drawdown_param_adj = case_when(age_grp>="[65,70)" & year<=10 ~ other_asset_drawdown_param*1.05^year,
                                                    age_grp>="[65,70)" & year>10 ~ other_asset_drawdown_param*1.05^10,
                                                    TRUE ~ other_asset_drawdown_param),
         ## housing: at net drawdown ages (70+) housing drawdown increase by 15% each year for next 10 years and then stay stable
         housing_asset_saving_param_adj = case_when(housing_asset_saving_param<0 & year<=10 ~ housing_asset_saving_param*1.15^year,
                                                    housing_asset_saving_param<0 & year>10 ~ housing_asset_saving_param*1.15^10,
                                                    TRUE ~ housing_asset_saving_param))

# other_asset_drawdown_plot <- ggplot(drawdown_adj %>% select(age_grp, ho, year, contains("other_asset")) %>% 
#                                       filter(age_grp>="[65,70)" & ho!=-1) %>% 
#                                       pivot_longer(cols=contains("other_asset"), names_to="drawdown_type", values_to="drawdown_val")) +
#   geom_line(aes(x=year, y=drawdown_val, colour=drawdown_type)) +
#   facet_grid(age_grp ~ ho)
# 
# housing_drawdown_plot <- ggplot(drawdown_adj %>% select(age_grp, ho, year, contains("housing")) %>% 
#                                       filter(age_grp>="[70,75)" & ho!=-1) %>% 
#                                       pivot_longer(cols=contains("housing"), names_to="drawdown_type", values_to="drawdown_val")) +
#   geom_line(aes(x=year, y=drawdown_val, colour=drawdown_type)) +
#   facet_grid(age_grp ~ ho)


# Put into new version of starting_cohorts, convert to year list and save --------

starting_cohorts_pathways_adj <- starting_cohorts_pathways %>% 
  left_join(drawdown_adj) %>% 
  ## replace values
  mutate( other_asset_drawdown_param = other_asset_drawdown_param_adj,
          housing_asset_saving_param = housing_asset_saving_param_adj)


## split into list by year - save for use in model running
year_list_0 <- starting_cohorts_pathways_adj %>% 
  split(., .$year) 

qsave(year_list_0, "./Output data/year_list_0_increase_drawdowns_larger.qs")
